import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { isEmpty } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { ConfirmationType } from '../../../../models/ui/Confirmations';
import { StagePatcherOptions } from './StagePatcherOptions';

const confirmationList = [
   {
      id: ConfirmationType.SsdBandwidth,
      title: 'SSD I/O',
      description:
         'You did not specify a limit of SSD bandwidth. Do you want us to specify default values of 30 Mb/s per pod? You can always change these values on the Stage settings page.',
   },
   {
      id: ConfirmationType.DiskIsolation,
      title: 'Disk Isolation',
      description: 'You did not enable Disk Isolation. Enable Disk Isolation for the deploy unit.',
   },
];

const deployUnitsConfirmations = {
   du1: new Set([ConfirmationType.SsdBandwidth]),
   du2: new Set([ConfirmationType.SsdBandwidth, ConfirmationType.DiskIsolation]),
   du3: new Set([ConfirmationType.DiskIsolation]),
};

export const SeveralDU = () => (
   <StagePatcherOptions
      deployUnitsConfirmations={deployUnitsConfirmations}
      confirmationList={confirmationList}
      needUpdates={!isEmpty(confirmationList)}
      onChange={action('change')}
   />
);

export const SingleDU = () => (
   <StagePatcherOptions
      deployUnitsConfirmations={{ du2: deployUnitsConfirmations.du2 }}
      confirmationList={confirmationList}
      needUpdates={!isEmpty(confirmationList)}
      onChange={action('change')}
   />
);

export default {
   title: 'pages/stages/StagePatcherOptions',
} as Meta;
