import { BYTES, ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import {
   DEFAULT_HDD_BANDWIDTH_GUARANTEE,
   DEFAULT_NETWORK_BANDWIDTH_GUARANTEE,
   DEFAULT_SSD_BANDWIDTH_GUARANTEE,
   EXTERNAL_LINKS,
} from '../../../../models';

export function SecretsMigrationHint() {
   return (
      <>
         <p>
            There is a new mechanic to store secrets in pod agent. This mechanic don't store delegation tokens in the
            pod agent spec.
         </p>
         <p>Exist old secrets can be migrated to new storage.</p>
         <p>
            <ExternalLink href={EXTERNAL_LINKS.deployDocs.secrets}>Details</ExternalLink>
         </p>
      </>
   );
}

export function PatchersRevisionHint() {
   return (
      <>
         Enable new runtime version for{' '}
         <ExternalLink href={EXTERNAL_LINKS.deployDocs.patchersRevision}>new features</ExternalLink>.
      </>
   );
}

export function HddBandwidthHint() {
   return (
      <>
         <p>You did not specify a limit of HDD bandwidth.</p>
         <p>
            Do you want us to specify default values of <code>{DEFAULT_HDD_BANDWIDTH_GUARANTEE / BYTES.MB} Mb/s</code>{' '}
            per pod?
         </p>
         <p>Bandwidth limit will be equal to bandwidth guarantee multiplied by factor 2.</p>
         <p>You can always change these values on the Stage settings page.</p>
      </>
   );
}

export function SsdBandwidthHint() {
   return (
      <>
         <p>You did not specify a limit of SSD bandwidth.</p>
         <p>
            Do you want us to specify default values of <code>{DEFAULT_SSD_BANDWIDTH_GUARANTEE / BYTES.MB} Mb/s</code>{' '}
            per pod?
         </p>
         <p>Bandwidth limit will be equal to bandwidth guarantee.</p>
         <p>You can always change these values on the Stage settings page.</p>
      </>
   );
}

export function NetworkBandwidthHint() {
   return (
      <>
         <p>You did not specify a guarantee of network bandwidth.</p>
         <p>
            Do you want us to specify default values of{' '}
            <code>{DEFAULT_NETWORK_BANDWIDTH_GUARANTEE / BYTES.MB} Mb/s</code> per pod?
         </p>
         <p>Bandwidth limit will remain untouched.</p>
         <p>You can always change these values on the Stage settings page.</p>
      </>
   );
}

export function DiskIsolationHint() {
   return (
      <>
         <p>You did not enable Disk Isolation.</p>
         <div>
            <ExternalLink href={'https://clubs.at.yandex-team.ru/infra-cloud/1345'}>Details</ExternalLink>
         </div>
      </>
   );
}

export function SidecarLabelRevisionHint({ sidecarTitle }: { sidecarTitle: string }) {
   return <p>New sandbox resource revision is available for {sidecarTitle}.</p>;
}
