import { faExclamationTriangle } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon, FontAwesomeIconProps } from '@fortawesome/react-fontawesome';
import React from 'react';

import classes from './OverQuota.module.css';

export const OverQuota: React.FC<{ size?: FontAwesomeIconProps['size'] }> = React.memo(({ size = 'lg' }) => (
   <FontAwesomeIcon icon={faExclamationTriangle} size={size} fixedWidth={true} className={classes.icon} />
));
OverQuota.displayName = 'OverQuota';
