import { faLongArrowRight } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { StageQuotaResourceGroups, stageQuotaUnit } from '../../../../models/ui/stage/resources';
import { resourcesModel } from '../../../../modules/resources/config';
import { MeasureUnitMode, MeasureViewMode } from '../../../../utils';
import { OverQuota } from './OverQuota';

import classes from './StageQuotaCell.module.css';

interface Props {
   usage: number;
   total: number;
   newValue: number;
   oldValue: number;
   resourceGroup: StageQuotaResourceGroups;
   viewMode: boolean;
   withDetails?: boolean;
}

export const StageQuotaCell: React.FC<Props> = React.memo(
   ({ usage, total, newValue, oldValue, resourceGroup, viewMode, withDetails = false }) => {
      const { resource } = resourcesModel[resourceGroup]!;

      const { getValueView } = resource;

      const [groupUnit, groupAtomUnit] = stageQuotaUnit[resourceGroup];

      // используемая квота без учета текущего стейджа
      const actualUsage = usage - oldValue;

      // доступная квота для текущего стейджа
      const available = total - actualUsage;

      // доступная квота к добавлению
      const currentAvailable = available - newValue;

      const isChanged = oldValue !== newValue;
      const isOverQuota = newValue > available;
      const isMore = newValue > oldValue;
      const isLess = newValue < oldValue;

      const view = (value: number, mode = MeasureViewMode.OnlyValue) =>
         getValueView(value, {
            unit: groupUnit,
            unitMode: MeasureUnitMode.Custom,
            viewMode: mode,
         });

      const viewAtom = (value: number) =>
         getValueView(value, {
            unit: groupAtomUnit,
            unitMode: MeasureUnitMode.Custom,
         });

      return (
         <div>
            <div>
               {isOverQuota && <OverQuota size={'sm'} />}

               {!viewMode && isChanged && (
                  <span>
                     <span title={viewAtom(oldValue)}>{view(oldValue)}</span>{' '}
                     <span
                        className={classNames(classes.arrow, {
                           [classes.more]: isMore,
                           [classes.less]: isLess,
                        })}
                     >
                        <FontAwesomeIcon icon={faLongArrowRight} className={classes.arrow} />
                     </span>
                  </span>
               )}
               {newValue === 0 && !isChanged ? (
                  '—'
               ) : (
                  <>
                     <span
                        className={classNames({
                           [classes.newValue]: isChanged,
                        })}
                        title={viewAtom(newValue)}
                     >
                        {view(newValue)}
                     </span>
                     <span> {view(newValue, MeasureViewMode.OnlyUnit)}</span>
                  </>
               )}
            </div>
            <div className={classes.available}>
               {currentAvailable <= 0 ? (
                  'No available'
               ) : (
                  <span>
                     <span title={viewAtom(currentAvailable)}>{view(currentAvailable, MeasureViewMode.All)}</span>{' '}
                     available
                  </span>
               )}
            </div>
            {withDetails && (
               <div className={classes.stats}>
                  <span title={viewAtom(usage)}>{view(usage)}</span> /{' '}
                  <span title={viewAtom(total)}>{view(total, MeasureViewMode.All)}</span>
               </div>
            )}
         </div>
      );
   },
);
StageQuotaCell.displayName = 'StageQuotaCell';
