import { FormLevelConfig } from '../huge-form';
import { boxLevelConfig, deployUnitLevelConfig, stageLevelConfig, workloadLevelConfig } from '../stage-levels';

export const levelConfigs = [stageLevelConfig, deployUnitLevelConfig, boxLevelConfig, workloadLevelConfig] as const;

type WithoutReadonly<T extends readonly any[]> = T extends readonly [infer X, ...infer Y]
   ? [X, ...Y]
   : T extends readonly (infer X)[]
   ? X[]
   : T;

type StageLevelConfigs = WithoutReadonly<typeof levelConfigs>;

export const configs = levelConfigs as StageLevelConfigs;

type GetLevelEmptyParams<T extends any[]> = T extends [FormLevelConfig<any, any, any, infer X>, ...infer Y]
   ? unknown extends X
      ? never
      : X | GetLevelEmptyParams<Y>
   : never;

type LevelEmptyParams = GetLevelEmptyParams<StageLevelConfigs>;
export type LevelEmptyParamsMap = Map<number, LevelEmptyParams>;
