import { useContext } from 'react';
import { SidecarName } from '../../../models/ui';
import { getSidecarResources, ResourcesContext } from '../../../models/ui/stage/resources';
import { useSidecarsQuota } from '../../../redux/hooks/useSidecarsQuota';

interface Props {
   sidecar: SidecarName;
   deployUnit: string;
   box: string;
   workload: string;
}
export function useSidecarResources({ sidecar, deployUnit, box = '', workload = '' }: Props) {
   const { stageSidecarsStore, stageDiskTypeStore, stagePatcherRevisions } = useContext(ResourcesContext);

   const defaultSidecarQuota = useSidecarsQuota();

   const params = {
      sidecar,
      deployUnit,
      box,
      workload,
      stageSidecarsStore,
      stageDiskTypeStore,
      stagePatcherRevisions,
      defaultSidecarQuota,
   };

   return getSidecarResources(params);
}
