/* eslint-disable react-hooks/exhaustive-deps */
import { useDismounted } from '@yandex-infracloud-ui/libs';
import { useCallback, useContext, useMemo } from 'react';
import { useDispatch } from 'react-redux';
import { useHistory } from 'react-router';

import { NotificationsContext } from '../../../models';
import { Stage } from '../../../models/ui';
import { handlersGenerator } from '../handlersGenerator';
import { StageHugeFormMode } from '../models';

interface UseStageCreateFormActionsProps {
   rootFormId: string;
   editedValue: Stage;
}

/**
 * Содержательные действия над стейджом в форме создания
 */
export function useStageCreateFormActions({ rootFormId, editedValue }: UseStageCreateFormActionsProps) {
   const notifications = useContext(NotificationsContext);
   const dismounted = useDismounted();
   const dispatch = useDispatch();
   const history = useHistory();

   const generator = useMemo(
      () =>
         handlersGenerator({
            dismounted,
            dispatch,
            history,
            mode: StageHugeFormMode.New,
            notifications,
         }),
      [dispatch, dismounted, notifications, history],
   );

   const stageReset = useCallback(
      generator.getStageResetHandler({
         rootFormId,
      }),
      [rootFormId, generator.getStageResetHandler],
   );

   const handleDeploy = useCallback(
      generator.getNewStageDeployHandler({
         editedValue,
         stageReset,
      }),
      [editedValue, stageReset, generator.getNewStageDeployHandler],
   );

   return {
      handleDeploy,
      stageReset,
   };
}
