import { useDismounted } from '@yandex-infracloud-ui/libs';
import { useCallback, useContext, useMemo } from 'react';
import { useDispatch } from 'react-redux';
import { useHistory } from 'react-router';

import { NotificationsContext } from '../../../models';
import { Stage } from '../../../models/ui';
import { TStage } from '../../../proto-typings';
import { handlersGenerator } from '../handlersGenerator';
import { StageHugeFormMode } from '../models';

interface UseStageEditFormActionsProps {
   editedValue: Stage;
   mode: StageHugeFormMode;
   rawStage: TStage;
   latestRawStage: TStage | undefined;
   // revisionTimestamp?: number; TODO https://st.yandex-team.ru/DEPLOY-3723
   rootFormId: string;
   stageId: string;
}

/**
 * Содержательные действия над стейджом в форме редактирования
 */
export function useStageEditFormActions({
   editedValue,
   mode,
   rawStage,
   latestRawStage,
   rootFormId,
   stageId,
}: UseStageEditFormActionsProps) {
   const notifications = useContext(NotificationsContext);
   const dismounted = useDismounted();
   const dispatch = useDispatch();
   const history = useHistory();

   const generator = useMemo(
      () =>
         handlersGenerator({
            dismounted,
            dispatch,
            history,
            mode,
            notifications,
         }),
      [mode, dispatch, dismounted, notifications, history],
   );

   // eslint-disable-next-line react-hooks/exhaustive-deps
   const stageReset = useCallback(
      generator.getStageResetHandler({
         rootFormId,
      }),
      [rootFormId, generator.getStageResetHandler],
   );

   // eslint-disable-next-line react-hooks/exhaustive-deps
   const handleDeploy = useCallback(
      generator.getStageDeployHandler({
         editedValue,
         latestRawStage,
         rawStage,
         stageId,
         stageReset,
      }),
      [editedValue, rawStage, stageId, stageReset, generator.getStageDeployHandler],
   );

   // eslint-disable-next-line react-hooks/exhaustive-deps
   const handleDeployDraft = useCallback(
      generator.getStageDeployDraftHandler({
         editedValue,
         rawStage,
         stageId,
         stageReset,
      }),
      [editedValue, rawStage, stageId, stageReset, generator.getStageDeployDraftHandler],
   );

   return {
      handleDeploy,
      handleDeployDraft,
      stageReset,
   };
}
