import { useEffect, useMemo, useState } from 'react';
import { DeepPartial } from '../../../models';
import { Stage, stageLevels, stagePaths } from '../../../models/ui';
import { TProject } from '../../../proto-typings';
import { formName } from '../../../utils';
import { FormChangeListener } from '../../huge-form';

export function useStageFormAbc(stage: Stage, project: DeepPartial<TProject> | null) {
   // #DEPLOY-5653 use stage account_id or project account_id
   const initialAbc = useMemo(() => (stage.project?.accountId || project?.spec?.account_id) ?? null, [
      stage.project?.accountId,
      project?.spec?.account_id,
   ]);

   const [abc, setAbc] = useState(initialAbc);

   useEffect(() => {
      setAbc(initialAbc);
   }, [initialAbc]);

   const abcChangeListener: FormChangeListener = useMemo(
      () => ({
         listenFields: {
            [stageLevels.stage.id]: [formName(stagePaths.project.accountId)],
         },
         onChange({ path, newValue }) {
            if (path === formName(stagePaths.project.accountId)) {
               setAbc(newValue);
            }
         },
      }),
      [],
   );

   return {
      initialAbc,
      abc,
      abcChangeListener,
   };
}
