import { useEffect, useMemo, useState } from 'react';
import { DeployUnitFormParams, duPaths, Stage } from '../../../models/ui';
import { getStagePatcherRevisions } from '../../../models/ui/stage/resources';
import { formName, getEmptyStoreAction, updateStore } from '../../../utils';
import { FormChangeListener, FormChangeType } from '../../huge-form';

export function useStageFormPatcherRevisions(stage: Stage, isNewQuota: boolean) {
   const initStagePatcherRevisions = useMemo(() => getStagePatcherRevisions(stage), [stage]);

   const oldStagePatcherRevisions = useMemo(() => (isNewQuota ? {} : initStagePatcherRevisions), [
      initStagePatcherRevisions,
      isNewQuota,
   ]);

   const [newStagePatcherRevisions, setNewStagePatcherRevisions] = useState(initStagePatcherRevisions);

   // сброс формы
   useEffect(() => {
      setNewStagePatcherRevisions(initStagePatcherRevisions);
   }, [initStagePatcherRevisions]);

   const patcherRevisionsChangeListener: FormChangeListener = useMemo(
      () => ({
         listenFields: {
            deployUnit: [formName(duPaths.patchersRevision.value)],
         },
         onChange({ newValue, formValues, type }) {
            const { id } = formValues;
            const revision = newValue as DeployUnitFormParams['patchersRevision']['value'];
            const action = getEmptyStoreAction<number>();

            if (type !== FormChangeType.Remove && revision) {
               action.write[id] = { value: revision };
            } else {
               action.delete.push(id);
            }

            setNewStagePatcherRevisions(store => updateStore(store, action));
         },
      }),
      [],
   );

   return {
      oldStagePatcherRevisions,
      newStagePatcherRevisions,
      patcherRevisionsChangeListener,
   };
}
