import { useCallback, useEffect, useMemo, useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { YpPaths } from '../../../models/api';
import { Stage, stageLevels, stagePaths } from '../../../models/ui';
import { EObjectType } from '../../../proto-typings';
import { getProjects, RootState, selectProject } from '../../../redux';
import { formName } from '../../../utils';
import { FormChangeListener } from '../../huge-form';

export function useStageFormProject(value: Stage, paths?: YpPaths<EObjectType.OT_PROJECT>) {
   const initialProjectId = useMemo(() => (value.project?.id ?? null) as null | string, [value.project?.id]);
   const [projectId, setProjectId] = useState(initialProjectId);

   // сброс формы
   useEffect(() => {
      setProjectId(initialProjectId);
   }, [initialProjectId]);

   const currentProject = useSelector(projectId ? (s: RootState) => selectProject(s, projectId) : () => null);

   const projectChangeListener: FormChangeListener = useMemo(
      () => ({
         listenFields: {
            [stageLevels.stage.id]: [formName(stagePaths.project.id)],
         },
         onChange({ path, newValue }) {
            if (path === formName(stagePaths.project.id)) {
               setProjectId(newValue);
            }
         },
      }),
      [],
   );

   const dispatch = useDispatch();

   const getProject = useCallback((id: string) => dispatch(getProjects({ ids: [id], paths })), [dispatch, paths]);

   useEffect(() => {
      if (projectId) {
         getProject(projectId);
      }
   }, [getProject, projectId]);

   return {
      projectId,
      project: currentProject,
      /** никогда не меняется */
      projectChangeListener,
   };
}
