import { useMemo } from 'react';
import { StagePodCountStore } from '../../../models/ui/stage/resources';
import { restoreObjectFromKey, useArrayMemo } from '../../../utils';

export function useStageFormUsedClusters(podCountStore: StagePodCountStore, allowEmpty = true) {
   const usedClusters = useMemo(
      () => [
         ...new Set(
            Object.keys(podCountStore)
               .filter(e => allowEmpty || podCountStore[e] > 0)
               .map(e => restoreObjectFromKey(e).location),
         ),
      ],
      [allowEmpty, podCountStore],
   );

   return useArrayMemo(usedClusters);
}
