import { isEqualWith } from 'lodash-es';

import { TStage } from '../../proto-typings';
import { Stage, StageConverter } from '../../models/ui';
import { getValueFromYaml } from '../../utils';
import { AnySubForm } from '../huge-form';

export enum StageHugeFormMode {
   Apply = 'apply',
   ApplyAsIs = 'applyAsIs',
   Edit = 'edit',
   New = 'new',
   View = 'view',
   Update = 'update',
}

export enum StageHugeFormShowPage {
   Edit = 'edit',
   Diff = 'diff',
   Update = 'update',
}

export enum StageHugeFormEditView {
   Form = 'form',
   Raw = 'raw',
}

export function getStageValueFromYaml(
   yamlText: string,
): { value: Stage | null; error: string | null; rawValue: TStage | null } {
   const { value, error } = getValueFromYaml<TStage>(yamlText);

   return { value: value ? StageConverter.fromApi(value) : null, error, rawValue: value };
}

export function isEqualStageForms(formA: AnySubForm, formB: AnySubForm): boolean {
   return isEqualWith(formA.formParams, formB.formParams, (valueA, valueB, name) => {
      if (name && typeof name === 'string' && name.startsWith('_')) {
         return true;
      }
      return undefined;
   });
}
