import { ExternalLink, isEmpty } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { EXTERNAL_LINKS } from '../../../../models';

const rbtorrentRegExp = RegExp(/^rbtorrent:[a-f0-9]{40}$/);

export const isRbtorrentUrl = (url: string | null) => {
   if (!url || isEmpty(url)) {
      return false;
   }

   if (rbtorrentRegExp.test(url)) {
      return true;
   }

   return false;
};

export const RbtorrentWarning: React.FC<{ url: string | null }> = React.memo(({ url }) =>
   isRbtorrentUrl(url) ? (
      <>
         Rbtorrent resources can be deleted due TTL. Use SBR instead. See{' '}
         <ExternalLink href={EXTERNAL_LINKS.deployDocs.resourceUrl}>documentation</ExternalLink> for details.
      </>
   ) : null,
);

RbtorrentWarning.displayName = 'RbtorrentWarning';
