import { ExtendedFieldConfig, FieldLayout2, InputField2, useExtendedField } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { isSandboxUrl, SandboxUrl } from './SandboxUrl';
import { isRbtorrentUrl, RbtorrentWarning } from './RbtorrentWarning';

import classes from './SandboxUrlField.module.css';

export const SandboxUrlField = React.memo((props: ExtendedFieldConfig<any, string>) => {
   const { field, readonly, disabled } = useExtendedField(props);
   const { controlProps } = props;

   return (
      <FieldLayout2 {...props}>
         <div className={classes.input}>
            <InputField2
               name={field.name}
               label={null}
               disabled={disabled}
               readonly={readonly}
               help={!readonly && isRbtorrentUrl(field.value) ? <RbtorrentWarning url={field.value} /> : undefined}
               hideErrors={true}
               controlProps={controlProps}
            />
         </div>

         {isSandboxUrl(field.value) ? (
            <div className={classes.link}>
               <SandboxUrl url={field.value} />
            </div>
         ) : null}
      </FieldLayout2>
   );
});

SandboxUrlField.displayName = 'SandboxUrlField';
