import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { apiServicesContextDecorator } from '../../../../stories';
import { DevForm } from '../../../lib';

import { YasmTagsSubForm } from './YasmTagsSubForm';

const initialValues = {
   yasmTags: {
      itype: 'deploy-ui',
      tags: [
         {
            key: 'ctype',
            value: 'custom',
         },
         {
            key: 'geo',
            value: 'sas',
         },
      ],
   },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <YasmTagsSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'yasmTags'}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/_common/YasmTagsSubForm',
   decorators: [apiServicesContextDecorator],
} as Meta;
