import { faPlus } from '@fortawesome/pro-regular-svg-icons';
import { FormButton, isEmpty } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React, { useCallback } from 'react';

import { YasmTags } from '../../../../models/ui';

import { ITypeSubForm } from './ITypeSubForm';
import { TagSubForm } from './TagSubForm';

import classes from './YasmTagsSubForm.module.css';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const YasmTagsSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<YasmTags>(name);

   const handleAddTag = useCallback(() => {
      const newTags = [...value.tags, { key: null, value: null }];

      form.setFieldValue(`${name}.tags`, newTags);
   }, [form, name, value.tags]);

   const handleRemoveTag = useCallback(
      (i: number) => {
         const newTags = [...value.tags];
         newTags.splice(i, 1);

         form.setFieldTouched(`${name}.tags[${i}]`, false);
         form.setFieldValue(`${name}.tags`, newTags);
      },
      [form, name, value.tags],
   );

   return (
      <>
         <ITypeSubForm name={`${name}.itype`} label={'YASM itype'} readonly={readonly} disabled={disabled} />

         {value.tags?.map((row, i) => (
            // eslint-disable-next-line react/no-array-index-key
            <div className={classes.tag} key={i} data-e2e={'YasmTag'}>
               <TagSubForm
                  index={i}
                  name={`${name}.tags[${i}]`}
                  itype={value.itype}
                  disabled={isEmpty(value.itype) || disabled}
                  readonly={readonly}
                  onRemove={handleRemoveTag}
               />
            </div>
         ))}

         {isEmpty(value.itype) || disabled || readonly ? null : (
            <FormButton onClick={handleAddTag} skipLeftSpace={true} icon={faPlus} dataE2e={'YasmTags:AddTag'}>
               Add tag
            </FormButton>
         )}
      </>
   );
});

YasmTagsSubForm.displayName = 'YasmTagsSubForm';
