import { useMemo } from 'react';

import { DeployUnitContextValue } from '../../../modules/secrets';

import { AnySubForm } from '../../huge-form';

const extractId = (type: 'stage' | 'deployUnit', form: AnySubForm): string =>
   form.levelConfig.id === type
      ? form.formParams.id
      : form.parentForms.find(f => f.levelConfig.id === type)!.formParams.id;

/**
 * Для передачи значения в SecretsContext из форму любого уровня (ниже уровня stage, конечно)
 */
export function useSecretsContextValueFromForm(form: AnySubForm, reloadUsages: () => void): DeployUnitContextValue {
   return useMemo(
      () => ({
         stageId: extractId('stage', form),
         duId: extractId('deployUnit', form),
         reloadUsages,
      }),
      [form, reloadUsages],
   );
}
