/**
 * Рассчитывает readonly и disabled статусы обязательных, но редактируемых только для новых сущностей полей.
 *
 * Вынес в функцию, т.к. много раз повторяется
 *
 * Например DeployUnit.id, DeployUnit.type
 */

export function editOnlyForNewProps(
   readonly: boolean,
   disabled: boolean,
   isAdded: boolean | undefined,
   isRootEntityNew: boolean,
): { disabled: boolean; readonly: boolean; required: boolean } {
   return {
      readonly,
      disabled: disabled || (!isRootEntityNew && !isAdded),
      required: true,
   };
}
