import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { Box, DeployUnit, Stage } from '../../../../../models/ui';

import { stageLevelConfig } from '../../../stage/levelConfig';
import { deployUnitLevelConfig } from '../../../deployUnit/levelConfig';
import { boxLevelConfig } from '../../levelConfig';
import { BoxForm } from './BoxForm';

const box: Box = {
   ...boxLevelConfig.getEmptyValue(),
   id: 'test-box',
};

const deployUnit: DeployUnit = {
   ...deployUnitLevelConfig.getEmptyValue(),
   id: 'test-deployUnit',
};

const stage: Stage = {
   ...stageLevelConfig.getEmptyValue(),
   id: 'test-stage',
};

const form = {
   formParams: boxLevelConfig.valueToFormParams(box),
   hasChildren: false,
   id: 'test-box',
   levelConfig: boxLevelConfig,
   parentForms: [
      {
         formParams: deployUnitLevelConfig.valueToFormParams(deployUnit),
         hasChildren: true,
         id: 'test-deployUnit',
         levelConfig: deployUnitLevelConfig,
         parentForms: [],
         value: deployUnit,
      },
      {
         formParams: stageLevelConfig.valueToFormParams(stage),
         hasChildren: true,
         id: 'test-stage',
         levelConfig: stageLevelConfig,
         parentForms: [],
         value: stage,
      },
   ],
   value: box,
};

export const Regular = () => (
   <Formik initialValues={form.formParams} onSubmit={() => undefined}>
      {formik => (
         <BoxForm
            disabled={boolean('disabled', false)}
            form={form}
            formik={formik}
            isRootEntityNew={boolean('isRootEntityNew', false)}
            readonly={boolean('readonly', false)}
         />
      )}
   </Formik>
);

export default {
   title: 'components/stage-levels/box/BoxForm',
} as Meta;
