import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { DevForm } from '../../../../lib';

import { DockerSubForm } from './DockerSubForm';

const initialValues = {
   dockerImage: {
      enabled: true,
      name: 'docker-name',
      tag: '0.0.1',
   },
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DockerSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'dockerImage'}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/box/DockerSubForm',
} as Meta;
