import { ExternalLink, FieldLayout2, InputField2, isEmpty, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';

import { EXTERNAL_LINKS, YANDEX_DOCKER_REGISTRY } from '../../../../../models';
import { BoxDockerImage } from '../../../../../models/ui';
import { EnabledSwitcherField } from '../../../../forms';

import { DockerHint } from '../../hints';

import classes from './DockerSubForm.module.css';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const DockerSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<BoxDockerImage>(name);

   return (
      <FieldLayout2 name={name} label={'Docker image'} hint={<DockerHint />} hideErrors={true} bigLabel={true}>
         <div data-e2e={'Box:Docker'}>
            {!readonly || !value?.enabled ? (
               <div data-e2e={'Docker:Enabled'}>
                  <EnabledSwitcherField name={`${name}.enabled`} label={null} disabled={disabled} readonly={readonly} />
               </div>
            ) : null}

            {value.enabled ? (
               <div>
                  {readonly ? (
                     <div className={classes.readonly}>
                        {`${YANDEX_DOCKER_REGISTRY}${value?.name ?? '?'}:${value?.tag ?? '?'}`}
                     </div>
                  ) : (
                     <>
                        <div>
                           Try official{' '}
                           <ExternalLink href={EXTERNAL_LINKS.docs.rtcDockerImages}>RTC images</ExternalLink>
                        </div>

                        <div className={classes.settings}>
                           <div data-e2e={'Docker:Name'}>
                              <InputField2
                                 name={`${name}.name`}
                                 label={'Image name'}
                                 required={value.enabled}
                                 disabled={disabled}
                                 readonly={readonly}
                              />
                           </div>

                           <div data-e2e={'Docker:Tag'}>
                              <InputField2
                                 name={`${name}.tag`}
                                 label={'Tag name'}
                                 required={value.enabled}
                                 disabled={disabled}
                                 readonly={readonly}
                              />
                           </div>
                        </div>
                     </>
                  )}
               </div>
            ) : null}

            {!readonly && value.enabled ? (
               <WarningPlate theme={'info'}>
                  {YANDEX_DOCKER_REGISTRY}
                  {value.name && !isEmpty(value.name) ? value.name : '<image_name>'}:
                  {value.tag && !isEmpty(value.tag) ? value.tag : '<tag_name>'}
               </WarningPlate>
            ) : null}
         </div>
      </FieldLayout2>
   );
});

DockerSubForm.displayName = 'DockerSubForm';
