import { faTimes } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { InputField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React, { useCallback } from 'react';
import { LegoButton } from '../../../../../_lego';

import { JugglerBundle } from '../../../../../models/ui';

import classes from './BundleRow.module.css';

interface Props {
   index: number;
   name: string;

   readonly: boolean;
   disabled: boolean;

   onRemove(i: number): void;
}

export const BundleRow: React.FC<Props> = React.memo(({ index, name, readonly, disabled, onRemove }) => {
   const form = useFormikContext();
   const value: JugglerBundle = getIn(form.values, name);

   const handleRemove = useCallback(() => {
      onRemove(index);
   }, [index, onRemove]);

   return (
      <div className={classes.wrapper} data-test={`BundleRow:${index + 1}`}>
         <div className={classes.url} data-test={'BundleRow:Url'}>
            {readonly ? (
               value.url
            ) : (
               <InputField2
                  name={`${name}.url`}
                  label={null}
                  placeholder={'URL'}
                  readonly={readonly}
                  disabled={disabled}
               />
            )}
         </div>

         {/* TODO: <RemoveButton /> */}
         {!disabled && !readonly ? (
            <LegoButton
               theme={'clear'}
               onClick={handleRemove}
               controlAttrs={{ 'data-e2e': `Bundle${index + 1}:Clear` }}
            >
               <FontAwesomeIcon icon={faTimes} />
            </LegoButton>
         ) : null}
      </div>
   );
});

BundleRow.displayName = 'BundleRow';
