import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { BoxJugglerSettings } from '../../../../../models/ui';
import { DevForm } from '../../../../lib';
import { JugglerAgentSubForm } from './JugglerAgentSubForm';

const initialValues = {
   default: {
      enabled: true,
      bundles: [{ url: 'bundle1' }, { url: 'bundle2' }],
      port: 22,
   } as BoxJugglerSettings,
   withError: {} as BoxJugglerSettings,
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <JugglerAgentSubForm readonly={false} disabled={false} name={'default'} />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export function Disabled() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <JugglerAgentSubForm readonly={false} disabled={true} name={'default'} />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export function Readonly() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <JugglerAgentSubForm readonly={true} disabled={false} name={'default'} />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export function Playground() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <JugglerAgentSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'default'}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/box/fields/JugglerAgentSubForm',
} as Meta;
