import React from 'react';

import { EnumField2, EnumOption } from '@yandex-infracloud-ui/libs';

import { Box, BoxFormParams, CgroupFsMountMode, Workload } from '../../../../../models/ui';
import { SubForm } from '../../../../huge-form';

import { CGroupFsHint } from '../../hints';

// скрываем RW из доступных, пока на бекенде не дотестят
const MountModeOptions: EnumOption[] = [
   {
      value: CgroupFsMountMode.None,
      title: 'None',
   },
   {
      value: CgroupFsMountMode.ReadOnly,
      title: 'Read only',
   },
   // {
   //    value: CgroupFsMountMode.ReadWrite,
   //    title: 'Read/Write',
   // },
];

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
   form?: SubForm<BoxFormParams, Box, Workload>;
}

export const CgroupFsSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <EnumField2
      name={name}
      label={'Mount mode'}
      hint={<CGroupFsHint />}
      disabled={disabled}
      readonly={readonly}
      readonlyDots={readonly}
      controlProps={{ options: MountModeOptions }}
   />
));

CgroupFsSubForm.displayName = 'CgroupFsSubForm';
