import { DurationField, FieldLayout2, FormAdvancedSection, InputField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React, { useCallback } from 'react';

import { DynamicResourceAdvancedSettings, isBoxAdvancedSettingsEmpty } from '../../../../../models/ui';
import { EnabledSwitcher } from '../../../../forms';

import classes from './AdvancedSettingsSubForm.module.css';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const AdvancedSettingsSubForm: React.FC<Props> = React.memo(({ name, readonly, disabled }) => {
   const form = useFormikContext();
   const value: DynamicResourceAdvancedSettings = getIn(form.values, name);

   const handleDeduplicationChange = useCallback(
      (allowDeduplication: boolean) => {
         form.setFieldValue(`${name}.allowDeduplication`, allowDeduplication);
      },
      [form, name],
   );

   return (
      <FormAdvancedSection
         toggleText={'Advanced settings'}
         header={null}
         openedByDefault={readonly || !isBoxAdvancedSettingsEmpty(value)}
         hideToggleSwitch={readonly}
         bodyClassName={classes.advancedBody}
      >
         <div data-e2e={'NotifyPolicy:DeduplicationSwitcher'}>
            <FieldLayout2
               name={'allowDeduplication'}
               label={'Deduplication'}
               hideErrors={true}
               readonly={readonly}
               readonlyDots={readonly}
            >
               <EnabledSwitcher
                  name={`${name}.allowDeduplication`}
                  value={value.allowDeduplication ?? false}
                  onChange={handleDeduplicationChange}
                  disabled={disabled}
                  readonly={readonly}
               />
            </FieldLayout2>
         </div>

         <div className={readonly ? undefined : classes.formRow}>
            <InputField2
               name={`${name}.verification.checksum`}
               label={'Checksum'}
               disabled={disabled}
               readonly={readonly}
               readonlyDots={readonly}
            />

            <DurationField
               name={`${name}.verification.checkPeriodMs`}
               label={'Check period'}
               controlProps={{
                  useRenderDetails: false,
                  useMilliseconds: true,
               }}
               disabled={disabled}
               readonly={readonly}
               readonlyDots={readonly}
            />
         </div>

         <div className={readonly ? undefined : classes.formRow}>
            <InputField2
               name={`${name}.maxDownloadSpeed`}
               label={'Max download speed, Mbit/s'}
               disabled={disabled}
               readonly={readonly}
               readonlyDots={readonly}
               controlProps={{ controlProps: { min: 0 }, type: 'number' }}
            />
         </div>
      </FormAdvancedSection>
   );
});

AdvancedSettingsSubForm.displayName = 'AdvancedSettingsSubForm';
