import { EnumField2, FieldLayout2, IEnumOption, InputField2, TextField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React, { useCallback } from 'react';
import { DynamicResourceNotifyPolicy, DynamicResourceNotifyPolicyMode } from '../../../../../models/ui';

import classes from './NotifyPolicySubForm.module.css';

const options: IEnumOption[] = [
   { value: DynamicResourceNotifyPolicyMode.Http, title: 'HTTP' },
   { value: DynamicResourceNotifyPolicyMode.Exec, title: 'Exec' },
   { value: DynamicResourceNotifyPolicyMode.Disabled, title: 'Disabled' },
];

export interface Props {
   name: string;
   disabled?: boolean;
   readonly?: boolean;
}

export const NotifyPolicySubForm: React.FC<Props> = React.memo(({ name, disabled, readonly }) => {
   const form = useFormikContext();
   const value: DynamicResourceNotifyPolicy = getIn(form.values, name);

   const handlePolicyModeChange = useCallback(
      (mode: DynamicResourceNotifyPolicyMode) => {
         form.setFieldValue(`${name}.mode`, mode);
      },
      [form, name],
   );

   return (
      <FieldLayout2 name={name} label={'Notify policy'} hideErrors={true} readonly={readonly} readonlyDots={readonly}>
         <div className={classes.wrapper}>
            <EnumField2
               name={`${name}.mode`}
               label={null}
               onChange={handlePolicyModeChange}
               controlProps={{ options }}
               disabled={disabled}
               readonly={readonly}
            />

            {value.mode === DynamicResourceNotifyPolicyMode.Http && (
               <div className={classes.http}>
                  <InputField2
                     name={`${name}.httpAction.url`}
                     label={'URL'}
                     disabled={disabled}
                     readonly={readonly}
                     readonlyDots={readonly}
                     required={true}
                  />

                  <TextField2
                     name={`${name}.httpAction.expectedAnswer`}
                     label={'Expected answer'}
                     disabled={disabled}
                     readonly={readonly}
                     readonlyDots={readonly}
                     controlProps={{ minRows: 2, monospaceFont: true, readonlyPre: readonly }}
                  />
               </div>
            )}

            {value.mode === DynamicResourceNotifyPolicyMode.Exec && (
               <div className={classes.exec}>
                  <TextField2
                     name={`${name}.execAction.commandLine`}
                     label={!readonly ? 'Command line' : null}
                     help={!readonly ? "The command is simply exec'd, it is not run inside a shell" : undefined}
                     disabled={disabled}
                     readonly={readonly}
                     required={!readonly}
                     controlProps={{ monospaceFont: true, readonlyPre: readonly }}
                  />

                  <TextField2
                     name={`${name}.execAction.expectedAnswer`}
                     label={'Expected answer'}
                     disabled={disabled}
                     readonly={readonly}
                     readonlyDots={readonly}
                     controlProps={{ minRows: 2, monospaceFont: true, readonlyPre: readonly }}
                  />
               </div>
            )}
         </div>
      </FieldLayout2>
   );
});

NotifyPolicySubForm.displayName = 'NotifyPolicySubForm';
