import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { LogrotateConfig } from '../../../../../models/ui';
import { DevForm } from '../../../../lib';

import { LogrotateConfigSubForm } from './LogrotateConfigSubForm';

const initialValues = {
   default: {
      rawConfig: `/logs/*.log {
   rotate 3
   size 1G
   compress
   delaycompress
   missingok
   notifempty
   nocopytruncate
   postrotate
      ( echo 'CTL RELOAD HTTP/1.0' | nc localhost 80 ) || exit 0
   endscript
}`,
      runPeriodMillisecond: 3600000,
   } as LogrotateConfig,
   empty: {
      rawConfig: null,
      runPeriodMillisecond: null,
   } as LogrotateConfig,
};

export interface Args {
   name?: string;
   readonly?: boolean;
   disabled?: boolean;
}

const Template: Story<Args> = args => (
   <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
      {() => (
         <>
            <LogrotateConfigSubForm
               name={'default'}
               disabled={args.disabled ?? boolean('disabled', false)}
               readonly={args.readonly ?? boolean('readonly', false)}
               {...args}
            />
            <DevForm />
         </>
      )}
   </Formik>
);

export const Regular = Template.bind({});
Regular.args = {
   disabled: false,
   readonly: false,
};

export const ReadonlyRegular = Template.bind({});
ReadonlyRegular.args = {
   disabled: false,
   readonly: true,
};

export const ReadonlyEmpty = Template.bind({});
ReadonlyEmpty.args = {
   name: 'empty',
   disabled: false,
   readonly: true,
};

export const Playground = Template.bind({});
Playground.args = {};

export default {
   title: 'components/stage-levels/box/fields/LogrotateConfigSubForm',
} as Meta;
