import { DurationField, TextField2 } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';

import { Box, BoxFormParams, LogrotateConfig, SidecarName, Workload } from '../../../../../models/ui';
import { getInitialIds } from '../../../../../models/ui/stage/form-utils';
import { SubForm } from '../../../../huge-form';
import { SidecarResourcePlate } from '../../../../stage-huge-form/components';

import classes from './LogrotateConfigSubForm.module.css';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
   form?: SubForm<BoxFormParams, Box, Workload>;
}

export const LogrotateConfigSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name, form: subForm }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<LogrotateConfig>(name);

   const { deployUnit = '', box = '' } = subForm
      ? getInitialIds(subForm.formParams, subForm.parentForms, subForm.levelConfig.id)
      : {};

   return (
      <div className={classes.wrapper}>
         <div className={classes.rawConfig}>
            <TextField2
               name={`${name}.rawConfig`}
               label={'Raw config'}
               disabled={disabled}
               readonly={readonly}
               readonlyDots={readonly}
               controlProps={{ minRows: 2, monospaceFont: true, readonlyPre: readonly }}
            />
         </div>

         <DurationField
            name={`${name}.runPeriodMillisecond`}
            label={'Run period'}
            controlProps={{
               useRenderDetails: false,
               useMilliseconds: true,
            }}
            disabled={disabled}
            readonly={readonly}
            readonlyDots={readonly}
         />

         {value.rawConfig && <SidecarResourcePlate sidecar={SidecarName.LogRotate} deployUnit={deployUnit} box={box} />}
      </div>
   );
});

LogrotateConfigSubForm.displayName = 'LogrotateConfigSubForm';
