import React from 'react';

import { EnumField2, EnumOption } from '@yandex-infracloud-ui/libs';

import { Box, BoxFormParams, VolumeCreateMode, Workload } from '../../../../../models/ui';
import { SubForm } from '../../../../huge-form';

import { RootFsCreateModeHint } from '../../hints';

const CreateModeOptions: EnumOption[] = [
   {
      value: VolumeCreateMode.ReadWrite,
      title: 'Read/Write',
   },
   {
      value: VolumeCreateMode.ReadOnly,
      title: 'Read only',
   },
];

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
   form?: SubForm<BoxFormParams, Box, Workload>;
}

export const RootFsSettingsSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <EnumField2
      name={`${name}.createMode`}
      label={'Create mode'}
      hint={<RootFsCreateModeHint />}
      disabled={disabled}
      readonly={readonly}
      readonlyDots={readonly}
      controlProps={{ options: CreateModeOptions }}
   />
));

RootFsSettingsSubForm.displayName = 'RootFsSettingsSubForm';
