import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { DEFAULT_JUGGLER_PORT, EXTERNAL_LINKS } from '../../../models';

export function LogrotateConfigHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.logrotateConfig}>documentation</ExternalLink> for details.
      </p>
   );
}

export function ResolvConfHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.resolvConf}>documentation</ExternalLink> for details.
      </p>
   );
}

export function BindSkynetHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.bindSkynet}>documentation</ExternalLink> for details.
      </p>
   );
}

export function ResourceLimitHint() {
   return (
      <>
         <p>The box will be limited by the resources you defined in this field.</p>
         <p>The sum of resources in boxes cannot exceed pod resources.</p>
         <p>
            See <ExternalLink href={EXTERNAL_LINKS.deployDocs.box}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function EnvironmentHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.boxEnvironment}>documentation</ExternalLink> for details.
      </p>
   );
}

export function DockerHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.docker}>documentation</ExternalLink> for details.
      </p>
   );
}

export function BoxLayersHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.layers}>documentation</ExternalLink> for details.
      </p>
   );
}

export function BoxStaticResourcesHint() {
   return (
      <>
         <p>
            Mount point is a <strong>directory</strong> which will be created for the resource.
         </p>
         <p>
            See <ExternalLink href={EXTERNAL_LINKS.deployDocs.staticResources}>documentation</ExternalLink> for details.
         </p>
      </>
   );
}

export function DynamicResourcesHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.dynamicResources}>documentation</ExternalLink> for details.
      </p>
   );
}

export function JugglerAgentHint() {
   return (
      <>
         <p>
            Enable juggler subagent. See{' '}
            <ExternalLink href={EXTERNAL_LINKS.wiki.jugglerAgent}>documentation</ExternalLink> for details.
         </p>
         <p>
            {'Juggler subagent takes your quota '}
            <b>in addition</b>
            {' to requested in Deploy Unit: Disk Size (512MB per Box), RAM (256MB per Box), CPU (0.13 per Box). See '}
            <ExternalLink href={EXTERNAL_LINKS.deployDocs.jugglerAgent}>here</ExternalLink>
            {' for details.'}
         </p>
      </>
   );
}

export function JugglerPortHint() {
   return (
      <p>
         Default port is <code>{DEFAULT_JUGGLER_PORT}</code>
      </p>
   );
}

export function JugglerBundleHint() {
   return (
      <p>
         Juggler bundle resource (rbtorrent/http[s]).{' '}
         <ExternalLink href={EXTERNAL_LINKS.docs.jugglerBundlerBuild}>How to make a bundle</ExternalLink>
      </p>
   );
}

export function VirtualServiceIdsHint() {
   return <p>Virtual Service IDs</p>;
}

export function Ipv4AddressPoolIdHint() {
   return <p>IPv4 Address Pool ID</p>;
}

export function AccessPermissionsHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.accessPermissions}>documentation</ExternalLink> for details.
      </p>
   );
}

export function VolumeHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.volume}>documentation</ExternalLink> for details.
      </p>
   );
}

export function RootFsCreateModeHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.readonlyRootfs}>documentation</ExternalLink> for details.
      </p>
   );
}

export function CGroupFsHint() {
   return (
      <p>
         See <ExternalLink href={EXTERNAL_LINKS.deployDocs.cgroupfs}>documentation</ExternalLink> for details.
      </p>
   );
}
