import { faBoxOpen as faBoxOpenChanged } from '@fortawesome/free-solid-svg-icons';

import {
   Box,
   BoxFormParams,
   boxToFormParams,
   boxValidationSchema,
   getEmptyBox,
   formParamsToBox,
   stageLevels,
   Workload,
   ypViewConfig,
} from '../../../models/ui';
import { clearTokensFromEnvironment } from '../../../modules/environment';
import { FormLevelConfig } from '../../huge-form';
import { clearWorkloadOnClone } from '../workload/levelConfig';
import { BoxForm } from './components/BoxForm/BoxForm';

export const clearBoxOnClone = (b: Box) => {
   clearTokensFromEnvironment(b.environment);

   for (const wl of b.workloads) {
      clearWorkloadOnClone(wl);
   }
};

export const boxLevelConfig: FormLevelConfig<BoxFormParams, Box, Workload> = {
   clearOnClone: clearBoxOnClone,
   component: BoxForm,
   getEmptyValue: getEmptyBox,
   formParamsToValue: formParamsToBox,
   getChildren: b => b.workloads,
   icon: ypViewConfig.box.fontAwesomeIcon,
   iconChanged: faBoxOpenChanged,
   iconColor: ypViewConfig.box.cssColor,
   id: stageLevels.box.id,
   level: stageLevels.box.level,
   name: 'Box',
   renderTitle: () => 'Box settings',
   routePath: id => `/${ypViewConfig.box.smallPrefix}-${id}`,
   validationSchema: boxValidationSchema,
   valueToFormParams: boxToFormParams,
};
