import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { DeployUnit, Stage } from '../../../../../models/ui';
import { stageWithSecretsDecorator } from '../../../../../modules/secrets/storybook/stageWithSecretsDecorator';
import { SECRETS_DEMO_STAGE_ID } from '../../../../../modules/secrets/storybook/StageWithSecretStory';
import { apiServicesContextDecorator, configContextDecorator, routerDecorator } from '../../../../../stories';

import { stageLevelConfig } from '../../../stage/levelConfig';
import { deployUnitLevelConfig } from '../../levelConfig';
import { DeployUnitForm } from './DeployUnitForm';

const deployUnit: DeployUnit = {
   ...deployUnitLevelConfig.getEmptyValue(),
   id: 'test-du',
   locations: {
      sas: {
         enabled: true,
         podCount: 7,
         disruptionBudget: 3,
         maxTolerableDowntimeSeconds: null,
         maxTolerableDowntimePods: null,
         antiaffinity: { perNode: 3, perRack: null },
      },
   },
};

const stage: Stage = {
   ...stageLevelConfig.getEmptyValue(),
   id: 'test-stage',
};

const duId = 'du_manual_secrets';

const form = {
   formParams: deployUnitLevelConfig.valueToFormParams(deployUnit),
   hasChildren: false,
   id: 'test-du',
   levelConfig: deployUnitLevelConfig,
   parentForms: [
      {
         formParams: {
            ...stageLevelConfig.valueToFormParams(stage),
            id: SECRETS_DEMO_STAGE_ID,
         },
         hasChildren: true,
         id: 'test-stage',
         levelConfig: stageLevelConfig,
         parentForms: [],
         value: stage,
      },
   ],
   value: deployUnit,
};

export const Regular = () => (
   <Formik initialValues={form.formParams} onSubmit={() => undefined}>
      {formik => (
         <DeployUnitForm
            disabled={boolean('disabled', false)}
            form={form}
            formik={formik}
            isRootEntityNew={boolean('isRootEntityNew', false)}
            readonly={boolean('readonly', false)}
         />
      )}
   </Formik>
);

export default {
   decorators: [configContextDecorator, apiServicesContextDecorator, stageWithSecretsDecorator(duId), routerDecorator],
   title: 'components/stage-levels/deployUnit/DeployUnitForm',
} as Meta;
