import { isEmpty, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React, { useMemo } from 'react';

import { DeployUnitFormParams, DeployUnitType } from '../../../../models/ui';

import classes from './DeployUnitLocationWarnings.module.css';

export function DeployUnitLocationWarnings() {
   const form = useFormikContext<DeployUnitFormParams>();

   const podCount = useMemo(
      () =>
         Object.values(form.values.locations)
            .filter(location => location.enabled)
            .reduce((acc, location) => acc + (location.podCount ?? 0), 0),
      [form.values.locations],
   );

   const downtime = useMemo(() => {
      const { locations, type } = form.values;
      if (isEmpty(locations)) {
         return true;
      }
      let isDowntime = true;

      switch (type) {
         case DeployUnitType.PerCluster: {
            for (const location of Object.values(locations)) {
               const disruptionBudget = location.disruptionBudget ?? 0;
               const locationPodCount = location.podCount ?? 0;

               if (locationPodCount > disruptionBudget) {
                  isDowntime = false;
               }
            }

            break;
         }

         case DeployUnitType.MultiCluster: {
            const disruptionBudget = form.values.disruptionBudget ?? 0;

            if (podCount > disruptionBudget) {
               isDowntime = false;
            }

            break;
         }
      }

      return isDowntime;
   }, [form.values, podCount]);

   if (podCount === 0) {
      return (
         <WarningPlate className={classes.warning}>
            For your service to function you need to choose at least one pod in any location
         </WarningPlate>
      );
   }

   if (downtime) {
      return (
         <WarningPlate className={classes.warning}>
            Beware that current disruption budget policy can cause a temporary service downtime
         </WarningPlate>
      );
   }

   return null;
}

DeployUnitLocationWarnings.displayName = 'DeployUnitLocationWarnings';
