import { WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React, { useContext } from 'react';
import { Link } from 'react-router-dom';
import { urlBuilder } from '../../../../../../models';
import { AlertingSettings } from '../../../../../../models/ui';
import { EnabledSwitcherField } from '../../../../../forms';
import { HugeFormContext } from '../../../../../huge-form';
import { NotificationChannelSubForm } from './NotificationChannelSubForm';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const AlertingSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<AlertingSettings>(name);
   const { payload } = useContext(HugeFormContext);
   const { monitoringProject, projectId } = payload;

   return (
      <>
         <EnabledSwitcherField
            name={`${name}.state`}
            disabled={disabled || !monitoringProject}
            readonly={readonly}
            readonlyDots={readonly}
            label={'Alerting for deploy unit'}
         />
         {!monitoringProject && (
            <WarningPlate>
               Monitoring project is not configured.{' '}
               {projectId && (
                  <Link to={urlBuilder.project(projectId)} target={'_blank'}>
                     Set monitoring project
                  </Link>
               )}
            </WarningPlate>
         )}

         {monitoringProject && ( // настройки ниже имеют смысл только при наличии проекта мониторинга
            <>
               {value.state && (
                  <NotificationChannelSubForm
                     name={`${name}.notificationChannel`}
                     label={'Notification channel ID'}
                     disabled={disabled}
                     readonly={readonly}
                     project={monitoringProject}
                  />
               )}
            </>
         )}
      </>
   );
});

AlertingSubForm.displayName = 'AlertingSubForm';
