import { FieldLayout2 } from '@yandex-infracloud-ui/libs';
import React from 'react';
import { AlertingSubForm } from './Alerting/AlertingSubForm';
import { EnvironmentSubForm } from './Environment/EnvironmentsSubForm';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const DeployUnitSettingsForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => (
   <FieldLayout2 name={name} label={'Deploy Unit settings'} bigLabel={true} hideErrors={true}>
      <EnvironmentSubForm name={`${name}.environment`} readonly={readonly} disabled={disabled} />
      <AlertingSubForm name={`${name}.alerting`} readonly={readonly} disabled={disabled} />
   </FieldLayout2>
));

DeployUnitSettingsForm.displayName = 'DeployUnitSettingsForm';
