import { EnumField2, EnumOption, ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';
import { EnvironmentSettings } from '../../../../../../models/ui';

interface Props {
   name: string;
   readonly: boolean;
   disabled: boolean;
}

const EnvironmentSettingsOptions: EnumOption[] = [
   { value: EnvironmentSettings.UNKNOWN, title: 'Unknown' },
   { value: EnvironmentSettings.TESTING, title: 'Testing' },
   { value: EnvironmentSettings.PRESTABLE, title: 'Prestable' },
   { value: EnvironmentSettings.STABLE, title: 'Production' },
];

export const EnvironmentSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<EnvironmentSettings | null>(name);

   return (
      <>
         <EnumField2
            name={`${name}`}
            label={'Environment'}
            controlProps={{ options: EnvironmentSettingsOptions }}
            required={true}
            disabled={disabled}
            readonly={readonly}
            readonlyDots={readonly}
            hideErrors={true}
         />
         {(!value || value === EnvironmentSettings.UNKNOWN) && (
            <WarningPlate theme={'danger'}>
               Set environment! Read more in the{' '}
               <ExternalLink href={'https://clubs.at.yandex-team.ru/infra-cloud/2660'}>post</ExternalLink>
            </WarningPlate>
         )}
      </>
   );
});

EnvironmentSubForm.displayName = 'EnvironmentSubForm';
