import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';
import { getDefaultDisk } from '../../../../../models/ui';
import { DevForm } from '../../../../lib';

import { DisksSubForm } from './DisksSubForm';

const defaultDisk = getDefaultDisk();

const initialValues = {
   disk: [defaultDisk],
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <DisksSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  soxService={boolean('soxService', false)}
                  name={'disk'}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/deployUnit/DisksSubForm',
} as Meta;
