import { useFormikContext } from 'formik';
import React from 'react';

import { DeployUnitDisk } from '../../../../../models/ui';

import classes from './DisksSubForm.module.css';

import { DiskSubForm } from './DiskSubForm';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;

   soxService: boolean;
}

export const DisksSubForm: React.FC<Props> = React.memo(({ readonly, disabled, name, soxService }) => {
   const form = useFormikContext();
   const { value } = form.getFieldMeta<DeployUnitDisk[]>(name);

   return (
      <div className={classes.wrapper}>
         {value?.map((_, i: number) => (
            <DiskSubForm
               name={`${name}.[${i}]`}
               // eslint-disable-next-line react/no-array-index-key
               key={`disk-${i}`}
               index={i}
               disabled={disabled}
               readonly={readonly}
               soxService={soxService}
            />
         ))}
      </div>
   );
});

DisksSubForm.displayName = 'DisksSubForm';
