import React from 'react';

import { FieldLayout2, Hint } from '@yandex-infracloud-ui/libs';

import { DeployUnitDefaultEndpointSet } from '../../../../../models/ui';
import { DefinitionList } from '../../../../lib';
import { FormSubSection } from '../../../../forms';
import { TagList } from '../../../../forms/inputs/TagList/TagList';

import classes from './EndpointSetsSubForm.module.css';

export const DefaultEndpoint: React.FC<{ endpointSetPrefix: string; readonly: boolean }> = React.memo(
   ({ endpointSetPrefix, readonly }: { endpointSetPrefix: string; readonly: boolean }) => {
      const endpointList = [
         {
            name: 'Endpoint set ID',
            title: 'default endpoint id',
            content: endpointSetPrefix,
         },
         {
            name: 'Protocol',
            title: 'default endpoint protocol',
            content: DeployUnitDefaultEndpointSet.protocol,
         },
         {
            name: 'Port',
            title: 'default endpoint port',
            content: DeployUnitDefaultEndpointSet.port,
         },
         {
            name: 'Liveness limit ratio',
            title: 'default endpoint liveness limit ratio',
            content: DeployUnitDefaultEndpointSet.liveness_limit_ratio,
         },
      ];

      return (
         <FormSubSection>
            <FieldLayout2
               name={`${endpointSetPrefix}.name`}
               label={
                  <div className={classes.defaultEndpointHeader}>
                     <span>{endpointSetPrefix}</span>
                     <div className={classes.defaultEndpointHintBlock}>
                        <TagList
                           className={classes.defaultEndpointTag}
                           editable={false}
                           items={[
                              {
                                 name: 'default',
                                 value: 'default',
                              },
                           ]}
                        />
                        <Hint text={`Endpoint set was not specified in the spec and was generated automatically`} />
                     </div>
                  </div>
               }
               readonly={readonly}
               bigLabel={true}
            >
               <div>
                  <DefinitionList items={endpointList} />
               </div>
            </FieldLayout2>
         </FormSubSection>
      );
   },
);
