import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';
import { DevForm } from '../../../../lib';

import { EndpointSetsSubForm } from './EndpointSetsSubForm';

const initialValues = {
   endpointSets: [
      {},
      { id: 'es1', port: 80 },
      {
         id: 'es2',
         port: 333,
      },
   ],
};

export function Regular() {
   return (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <EndpointSetsSubForm
                  readonly={boolean('readonly', false)}
                  disabled={boolean('disabled', false)}
                  name={'endpointSets'}
                  endpointSetPrefix={'stage.deployUnit'}
               />
               <DevForm />
            </>
         )}
      </Formik>
   );
}

export default {
   title: 'components/stage-levels/deployUnit/EndpointSetsSubForm',
} as Meta;
