import { action } from '@storybook/addon-actions';
import { boolean, radios } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';
import { mixed, object } from 'yup';
import { LegoButton } from '../../../../../_lego';

import { DeployUnitLocationMap, DeployUnitType } from '../../../../../models/ui';
import { configContextDecorator } from '../../../../../stories';

import { LocationsSubForm } from './LocationsSubForm';

interface FormValue {
   test: DeployUnitLocationMap;
}

const initialValues: FormValue = {
   test: {
      sas: {
         enabled: true,
         antiaffinity: { perRack: 1, perNode: 1 },
         disruptionBudget: null,
         maxTolerableDowntimePods: null,
         maxTolerableDowntimeSeconds: null,
         podCount: 2,
      },
      man: {
         enabled: true,
         antiaffinity: { perRack: 1, perNode: 1 },
         disruptionBudget: null,
         maxTolerableDowntimePods: null,
         maxTolerableDowntimeSeconds: null,
         podCount: 1,
      },
   },
};

const validationSchema = object<FormValue>({
   test: mixed(),
   /* object().of(
      object<DeployUnitLocation>({
         cluster: string().required(),
         antiaffinity: mixed(),
         podCount: number().positive().required(),
         disruptionBudget: number().nullable(),
         maxTolerableDowntimePods: number().nullable(),
         maxTolerableDowntimeSeconds: number().nullable(),
      }),
   ), */
});

export const Regular = () => (
   <Formik initialValues={initialValues} onSubmit={action('onSubmit')} validationSchema={validationSchema}>
      {() => (
         <>
            <LocationsSubForm
               name={'test'}
               readonly={boolean('readonly', false)}
               disabled={boolean('disabled', false)}
               deployUnitType={radios(
                  'deployUnitType',
                  {
                     [DeployUnitType.MultiCluster]: DeployUnitType.MultiCluster,
                     [DeployUnitType.PerCluster]: DeployUnitType.PerCluster,
                  },
                  DeployUnitType.PerCluster,
               )}
            />

            <LegoButton type={'submit'}>Test submit</LegoButton>
         </>
      )}
   </Formik>
);

export default {
   decorators: [configContextDecorator],
   title: 'components/stage-levels/deployUnit/LocationsSubForm',
} as Meta;
