import React from 'react';

import { DeployUnitType } from '../../../../../models/ui';
import { useConfig } from '../../../../../services';

import { LocationCard } from './LocationCard';

import classes from './LocationsSubForm.module.css';

interface Props {
   name: string;
   readonly: boolean;
   disabled: boolean;
   deployUnitType: DeployUnitType;
}

export const LocationsSubForm: React.FC<Props> = React.memo(({ deployUnitType, readonly, disabled, name }) => {
   const { clusters } = useConfig()!;

   return (
      <div className={readonly ? classes.readonly : undefined}>
         {clusters.map(cluster => (
            <LocationCard
               key={cluster.value}
               name={`${name}[${cluster.value}]`}
               clusterName={cluster.name}
               disabled={disabled}
               readonly={readonly}
               deployUnitType={deployUnitType}
            />
         ))}
      </div>
   );
});

LocationsSubForm.displayName = 'LocationsSubForm';
