import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Formik } from 'formik';
import React from 'react';

import { LegoButton } from '../../../../../_lego';
import { DeployUnit, getEmptyDeployUnit } from '../../../../../models/ui';
import { configContextDecorator } from '../../../../../stories';

import { NetworkSubForm } from './NetworkSubForm';

const NetworkSubFormStory = (customSettings: boolean) => {
   const initialValues: DeployUnit = {
      ...getEmptyDeployUnit(),
      networkDefaults: {
         networkId: '_YA_DEPLOY_NETS_',
         customSettings,
         virtualServiceIds: ['a', 'b', 'c'],
         ipv4AddressPoolId: null,
      },
   };

   return () => (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <>
               <NetworkSubForm name={''} readonly={boolean('readonly', false)} disabled={boolean('disabled', false)} />

               <LegoButton type={'submit'}>Test submit</LegoButton>
            </>
         )}
      </Formik>
   );
};

export const Regular = NetworkSubFormStory(false);

export const customSettings = NetworkSubFormStory(true);

export default {
   decorators: [configContextDecorator],
   title: 'components/stage-levels/deployUnit/NetworkSubForm',
} as Meta;
