import { ExternalLink, FieldLayout2, InputField2, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React, { useMemo } from 'react';

import { Ipv4AddressPoolIdHint, VirtualServiceIdsHint } from '../../../box/hints';
import { MultipleInputField } from '../../../../forms/fields/MultipleInputField/MultipleInputField';
import { NetworkSuggest } from './NetworkSuggest/NetworkSuggest';
import { DeployUnit } from '../../../../../models/ui';
import classes from './NetworkSubForm.module.css';
import { EXTERNAL_LINKS } from '../../../../../models';

interface Props {
   name: string;
   disabled: boolean;
   readonly: boolean;
}

export const NetworkSubForm = React.memo(({ name, disabled, readonly }: Props) => {
   const form = useFormikContext();
   const { customSettings } = useMemo(() => (form.values as DeployUnit).networkDefaults, [form]);

   return (
      <div className={classes.wrapper}>
         <FieldLayout2
            name={name}
            readonly={readonly}
            disabled={disabled}
            label={'Network Settings'}
            bigLabel={true}
            hideErrors={true}
         >
            {!readonly && customSettings ? (
               <WarningPlate className={classes.networkWarningPlate}>
                  The ip6_address_requests has custom values. You should use{' '}
                  <ExternalLink href={EXTERNAL_LINKS.deployDocs.dctl}>DCTL</ExternalLink> to edit custom network
                  settings.
               </WarningPlate>
            ) : undefined}

            <NetworkSuggest name={`${name}.networkId`} readonly={readonly} disabled={disabled || customSettings} />

            <MultipleInputField
               disabled={disabled || customSettings}
               name={`${name}.virtualServiceIds`}
               readonly={readonly}
               controlProps={{
                  addText: 'Virtual Services',
                  hint: <VirtualServiceIdsHint />,
                  placeholder: 'Virtual Service ID',
               }}
               label={'Virtual Services'}
            />

            <InputField2
               name={`${name}.ipv4AddressPoolId`}
               readonly={readonly}
               disabled={disabled || customSettings}
               label={'IPv4 Address Pool ID'}
               readonlyDots={readonly}
               hint={<Ipv4AddressPoolIdHint />}
            />
         </FieldLayout2>
      </div>
   );
});

NetworkSubForm.displayName = 'NetworkSubForm';
