import { Meta, Story } from '@storybook/react';
import { Formik } from 'formik';
import React, { useState } from 'react';

import { PodNodeFilters } from '../../../../../models/ui';
import { DevForm } from '../../../../lib';

import { NodeFiltersSubForm } from './NodeFiltersSubForm';

const Template: Story<{ readonly: boolean; disabled: boolean }> = ({ readonly, disabled }) => {
   const [value, setValue] = useState({
      nodeFilters: {
         requireAvx: true,
         requireAvx2: true,
         requireBandwidth10G: true,
         requireIntel: false,
      } as PodNodeFilters,
   });

   return (
      <Formik initialValues={value} onSubmit={setValue}>
         {() => (
            <>
               <NodeFiltersSubForm name={'nodeFilters'} disabled={disabled} readonly={readonly} />

               <DevForm open={true} />
            </>
         )}
      </Formik>
   );
};

export const Regular = Template.bind({});

Regular.storyName = 'NodeFiltersSubForm'; // Remove if it isn't single story
Regular.args = { readonly: false, disabled: false };

export default {
   title: 'NodeFiltersSubForm',
} as Meta;
