import { CheckboxField2, classNames, WarningPlate } from '@yandex-infracloud-ui/libs';
import { useField } from 'formik';
import React from 'react';

import { PodNodeFilters } from '../../../../../models/ui';
import { FormSection } from '../../../../forms';

import classes from './NodeFiltersSubForm.module.css';

interface Props {
   className?: string;
   disabled: boolean;
   name: string;
   readonly: boolean;
}

export const NodeFiltersSubForm: React.FC<Props> = React.memo(({ name, className, readonly, disabled }) => {
   const [field] = useField<PodNodeFilters>(name);

   return (
      <>
         <div className={classNames(classes.wrapper, className)}>
            <FormSection title={'CPU requirements'} className={classes.cpu}>
               <CheckboxField2 name={`${name}.requireAvx`} label={null} disabled={disabled} readonly={readonly}>
                  Needs AVX
               </CheckboxField2>

               <CheckboxField2 name={`${name}.requireAvx2`} label={null} disabled={disabled} readonly={readonly}>
                  Needs AVX2
               </CheckboxField2>

               <CheckboxField2 name={`${name}.requireIntel`} label={null} disabled={disabled} readonly={readonly}>
                  Needs Intel
               </CheckboxField2>
            </FormSection>

            <FormSection title={'Network requirements'} className={classes.network}>
               <CheckboxField2
                  name={`${name}.requireBandwidth10G`}
                  label={null}
                  disabled={disabled}
                  readonly={readonly}
               >
                  10Gb/s bandwidth
               </CheckboxField2>
            </FormSection>
         </div>

         {!readonly && field.value.requireIntel && (
            <WarningPlate>
               <b>Beware!</b> In case of enabling "Need Intel" option you will not be able to use fresh, brand new, high
               performance CPUs and in future scheduling of your pods may take indefinitely long time. Consider this
               feature as temporary solution for legacy/unoptimized workload. We can drop support of this feature at any
               time after AMD 256 order and quotas settlement.
            </WarningPlate>
         )}
      </>
   );
});

NodeFiltersSubForm.displayName = 'NodeFiltersSubForm';
