import { FormAdvancedSection, isEmpty } from '@yandex-infracloud-ui/libs';
import { useFormikContext } from 'formik';
import React from 'react';

import { DeployUnitFormParams, Sidecar } from '../../../../../models/ui';
import { KeyValueField } from '../../../../forms';
import { SidecarResourceField } from '../../fields/SidecarResourceField/SidecarResourceField';

interface Props {
   disabled: boolean;
   name: string;
   readonly: boolean;
   sidecarName: string;
   sidecarSandboxId: string;
}

export const SidecarSubForm: React.FC<Props> = React.memo(
   ({ readonly, disabled, name, sidecarName, sidecarSandboxId }) => {
      const form = useFormikContext<DeployUnitFormParams>();

      const { value } = form.getFieldMeta<Sidecar>(name);
      const { labelRevision } = value;

      const opened = !isEmpty(Object.keys((value ?? {}).overrideLabels ?? []));

      return (
         <>
            <SidecarResourceField
               name={`${name}.resourceRevision`}
               label={null}
               readonly={readonly}
               disabled={disabled}
               labelRevision={labelRevision}
               sidecarName={sidecarName}
               sidecarSandboxId={sidecarSandboxId}
            />

            <FormAdvancedSection
               header={null}
               hasValue={false}
               title={'Override sandbox attributes'}
               openedByDefault={opened}
               hideToggleSwitch={readonly}
            >
               {/* TODO: это стоит переписать на стильную модную молодёжную сабформу */}
               <KeyValueField name={`${name}.overrideLabels`} label={null} readonly={readonly} disabled={disabled} />
            </FormAdvancedSection>
         </>
      );
   },
);

SidecarSubForm.displayName = 'SidecarSubForm';
