import { ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import { Button } from 'lego-on-react';
import React from 'react';

import { EXTERNAL_LINKS } from '../../../../../models';

import classes from './SidecarWarning.module.css';

interface Props {
   currentRevision: number | null;
   labelRevision: number;
   sidecarName: string;

   setLabelRevision(): void;
}

export function SidecarWarning({ currentRevision, labelRevision, setLabelRevision, sidecarName }: Props) {
   return (
      <WarningPlate
         theme={'info'}
         className={classes.warning}
         secondRaw={
            <div className={classes.row}>
               <div>
                  {currentRevision ? (
                     <span>
                        Current revision is{' '}
                        <ExternalLink href={EXTERNAL_LINKS.sandboxResource(currentRevision)}>
                           {currentRevision}
                        </ExternalLink>
                        .
                     </span>
                  ) : (
                     <span>Current revision is not specified</span>
                  )}
               </div>
               <div>
                  <Button theme={'normal'} size={'s'} onClick={setLabelRevision}>
                     Set revision <em>{labelRevision}</em>
                  </Button>
               </div>
            </div>
         }
      >
         Currently we advise resource revision{' '}
         <ExternalLink href={EXTERNAL_LINKS.sandboxResource(labelRevision)}>{labelRevision ?? 1836159075}</ExternalLink>{' '}
         for {sidecarName}.
      </WarningPlate>
   );
}
