import { faTimes } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { FieldLayout2, InputField2 } from '@yandex-infracloud-ui/libs';
import { getIn, useFormikContext } from 'formik';
import React, { useCallback } from 'react';

import { LegoButton } from '../../../../../_lego';
import { TvmClientItemRecord } from '../../../../../models/ui';

import { TvmDestinationHint } from './hints';
import classes from './TvmDestinationRow.module.css';

interface Props {
   name: string;
   index: number;
   readonly: boolean;
   disabled: boolean;
   required: boolean;
   canRemove: boolean;

   onRemove(i: number): void;
}

export const TvmDestinationRow: React.FC<Props> = React.memo(
   ({ name, index, readonly, disabled, required, canRemove, onRemove }) => {
      const form = useFormikContext();
      const value: TvmClientItemRecord = getIn(form.values, name);

      const handleRemove = useCallback(() => onRemove(index), [index, onRemove]);

      return (
         <tr className={readonly ? classes.readonly : undefined} data-e2e={`TvmDestination:${index + 1}`}>
            <td>
               <FieldLayout2
                  name={name}
                  label={'Destination'}
                  hint={readonly ? null : <TvmDestinationHint />}
                  readonly={readonly}
                  required={required}
                  hideErrors={true}
               />
            </td>
            <td>
               <InputField2
                  name={`${name}.app`}
                  label={null}
                  controlProps={{ controlProps: { min: 0 }, type: 'number' }}
                  readonly={readonly}
                  disabled={disabled}
                  hideErrors={true}
               />
            </td>
            <td>
               <InputField2
                  name={`${name}.alias`}
                  label={null}
                  placeholder={value.app?.toString() ?? ''}
                  readonly={readonly}
                  disabled={disabled}
                  hideErrors={true}
               />
            </td>
            <td>
               {/* TODO: <RemoveButton /> */}
               {disabled || readonly || !canRemove ? null : (
                  <LegoButton
                     theme={'clear'}
                     onClick={handleRemove}
                     controlAttrs={{ 'data-e2e': 'TvmDestination:RemoveButton' }}
                  >
                     <FontAwesomeIcon icon={faTimes} />
                  </LegoButton>
               )}
            </td>
         </tr>
      );
   },
);

TvmDestinationRow.displayName = 'TvmDestinationRow';
